package gov.va.med.mhv.phr.util;

import java.util.Collection;
import java.util.HashSet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.messages.Message;
import org.tigris.atlas.messages.MessageUtils;
import org.tigris.atlas.messages.Messages;
import org.tigris.atlas.service.VoidServiceResponse;

import gov.va.med.mhv.foiapareporting.service.PhrRequestCollectionServiceResponse;
import gov.va.med.mhv.foiapareporting.service.delegate.PhrRequestTrackingServiceDelegate;
import gov.va.med.mhv.foiapareporting.service.delegate.ServiceDelegateFactory;
import gov.va.med.mhv.foiapareporting.transfer.PhrRequest;
import gov.va.med.mhv.usermgmt.enumeration.ExtractType;
import gov.va.med.mhv.usermgmt.transfer.Facility;
import gov.va.med.mhv.usermgmt.transfer.FacilityInfo;
import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.usermgmt.transfer.UserProfile;

public class FoiaUtil {
	
	private static final Log LOG = LogFactory.getLog(FoiaUtil.class);
	private static PhrRequestTrackingServiceDelegate FOIA_SVC = null;
	
	private FoiaUtil() {}
	
	private static synchronized PhrRequestTrackingServiceDelegate getFoiaService() {
		if ( FOIA_SVC == null ) {
			FOIA_SVC = ServiceDelegateFactory.createPhrRequestTrackingServiceDelegate();
		}
		return FOIA_SVC;
	}
	
	public static Collection<PhrRequest> recordFoiaRequestInitiated(Patient patient) {
		PhrRequestTrackingServiceDelegate foiaSvc = getFoiaService();
		UserProfile user = patient.getUserProfile();
		Collection<FacilityInfo> facilityInfos = new HashSet<FacilityInfo>();
		for(Object facilityObj : patient.getFacilitys() ) {
			Facility fac = (Facility)facilityObj;
			facilityInfos.add(fac.getFacilityInfo());
		}
		PhrRequestCollectionServiceResponse resp = foiaSvc.createPendingRequests(user, facilityInfos);
		if ( resp.getMessages().hasErrorMessages() ) {
			logErrors(resp.getMessages(), "Error logging FOIA requests: ");
		}
		Collection<PhrRequest> result = resp.getPhrRequests();
		if ( LOG.isDebugEnabled()) {
			LOG.debug("recordFoiaRequestInitiated(" + user.getUserName() + ") returning " + result.size() + " requests.");
		}
		return result;
	}
	
	public static void recordFoiaRequestsGranted(Collection<PhrRequest> requests) {
		if ( LOG.isDebugEnabled()) {
			LOG.debug("recordFoiaRequestsGranted() updating " + requests.size() + " requests.");
		}
		if ( requests != null && !requests.isEmpty() ) {
			PhrRequestTrackingServiceDelegate foiaSvc = getFoiaService();
			VoidServiceResponse resp = foiaSvc.grantRequests(requests);
			if ( resp.getMessages().hasErrorMessages() ) {
			logErrors(resp.getMessages(), "Error marking FOIA requests granted: ");
			}
		}
	}

	private static void logErrors(Messages messages, String intro) {
		for(Object msgObj : messages.getErrorMessages()) {
			Message msg = (Message)msgObj;
			LOG.error(intro + " key: " + msg.getKey() 
					+ " inserts: " +  msg.getInserts()
					+ " class: " + msg.getClass());
		}
	}

	public static boolean isFoiaCountable(ExtractType extractType) {
		if ( extractType == null ) return false;
		return ExtractType.CHEMISTRYHEMATOLOGY.equals(extractType.getName());
	}

}
